using System;
using System.Collections.Generic;
using System.Linq;

public class Program
{
    public static long VektorskiProizvod(long[] niz, long[] a, long[] b)
    {
        return (a[0] - niz[0]) * (b[1] - niz[1]) - (a[1] - niz[1]) * (b[0] - niz[0]);
    }
    public static List<long[]> KonvOmotac(List<long[]> tacke)
    {
        tacke.Sort((a, b) =>
            a[0] != b[0] ? a[0].CompareTo(b[0]) : a[1].CompareTo(b[1]));
        List<long[]> donji = new List<long[]>();
        List<long[]> gornji = new List<long[]>();
        foreach (var p in tacke)
        {
            while (donji.Count >= 2 && VektorskiProizvod(donji[^2], donji[^1], p) <= 0)
            {
                donji.RemoveAt(donji.Count - 1);
            }
            donji.Add(p);
        }
        for (int i = tacke.Count - 1; i >= 0; i--)
        {
            var p = tacke[i];
            while (gornji.Count >= 2 && VektorskiProizvod(gornji[^2], gornji[^1], p) <= 0)
            {
                gornji.RemoveAt(gornji.Count - 1);
            }
            gornji.Add(p);
        }
        List<long[]> res = new List<long[]>();
        res.AddRange(donji.Take(donji.Count - 1));
        res.AddRange(gornji.Take(gornji.Count - 1));
        return res;
    }
    public static long PPoligona(List<long[]> polygon)
    {
        int n = polygon.Count;
        long P = 0;
        for (int i = 0; i < n; i++)
        {
            var p1 = polygon[i];
            var p2 = polygon[(i + 1) % n];
            P += p1[0] * p2[1] - p1[1] * p2[0];
        }
        return Math.Abs(P) / 2;
    }
    public static long SkoroKonv(List<long[]> tacke)
    {
        int n = tacke.Count;
        long minP = long.MaxValue;
        for (int i = 0; i < n; i++)
        {
            List<long[]> podskup = new List<long[]>();
            for (int j = 0; j < n; j++)
            {
                if (j != i)
                {
                    podskup.Add(tacke[j]);
                }
            }
            var omotac = KonvOmotac(podskup);
            long P = PPoligona(omotac);
            minP = Math.Min(minP, P);
        }
        return minP;
    }
    public static void Main(string[] args)
    {
        int n = int.Parse(Console.ReadLine());
        List<long[]> tacke = new List<long[]>();
        for (int i = 0; i < n; i++)
        {
            var x = Console.ReadLine().Split().Select(long.Parse).ToArray();
            tacke.Add(new long[] { x[0], x[1] });
        }
        long res = SkoroKonv(tacke);
        Console.WriteLine(res);
    }
}